/*   This file contains customized XDR filters needed to
 * to test the primitive XDR filters.
 */


#define MAXLENGTH 100



struct vararrint {
   int *data;
   int length;
};


struct vararrfloat {
   float *data;
   int   length;
};


bool_t
xdr_string_256(xdrs,cp)     /* xdr_string with maxsize hardcoded to 256 */
   XDR *xdrs;
   char **cp;
{
   return(xdr_string(xdrs,cp,256));
}


bool_t
xdr_opaque_8(xdrs,cp)       /* xdr_opaque with cnt hardcoded to 8 */
   XDR *xdrs;
   char *cp;
{
   return(xdr_opaque(xdrs,cp,8));
}


bool_t
xdr_opaque_9(xdrs,cp)       /* xdr_opaque with cnt hardcoded to 9 */
   XDR *xdrs;
   char *cp;
{
   return(xdr_opaque(xdrs,cp,9));
}


bool_t
xdr_opaque_10(xdrs,cp)      /* xdr_opaque with cnt hardcoded to 10 */
   XDR *xdrs;
   char *cp;
{
   return(xdr_opaque(xdrs,cp,10));
}


bool_t
xdr_opaque_11(xdrs,cp)      /* xdr_opaque with cnt hardcoded to 11 */    
   XDR *xdrs;
   char *cp;
{
   return(xdr_opaque(xdrs,cp,11));
}


bool_t
xdr_array_int(xdrs,arrp)
   XDR *xdrs;
   struct vararrint *arrp;
{
   return(xdr_array(xdrs,&arrp->data,&arrp->length,MAXLENGTH,sizeof(int),xdr_int));
}


bool_t
xdr_array_float(xdrs,arrp)
   XDR *xdrs;
   struct vararrfloat *arrp;
{
   return(xdr_array(xdrs,&arrp->data,&arrp->length,MAXLENGTH,sizeof(float),xdr_float));
}
/***** END OF FILE *****/
